#include <TDSConcentration.h>                         //βιβλιοθήκη περιεκτικότητας
#include <Liquid_Crystal.h>                           //βιβλιοθήκη οθόνης LCD

TDSConcentration myTDS(A1);                           // Ορισμός της θύρας του αισθητήρα


LiquidCrystal myLCD(0x27, 16, 2);                     // Διεύθυνση της LCD. Η σύνδεση γίνεται στη θύρα I2C

void setup() 
{
  Serial.begin(9600);                                  // Έναρξη του Serial Monitor
  myTDS.begin();                                       // Έναρξη του αισθητήρα TDS
  myLCD.begin();                                       // Έναρξη της LCD
}

void loop() 
{
  float concentration = myTDS.readConcentration();       // Ανάγνωση %w/w περιεκτικότητας
  
  myLCD.Text(String(concentration, 4).c_str(), 0, 0);   // Εμφάνιση τιμής περιεκτικότητας στην οθόνη LCD με 4 δεκαδικά ψηφία
  myLCD.Text("%w/w", 6, 0);                             // Κείμενο στη θέση 6,0

  delay(500);                                           // Καθυστέρηση για σταθερότητα
}
